/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.visitors.PublicApiChecker;
import org.sonar.java.checks.PatternUtils;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="UndocumentedApi", priority=Priority.MAJOR, tags={"convention"})
public class UndocumentedApiCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Tree.Kind[] CLASS_KINDS = PublicApiChecker.classKinds();
    private static final Tree.Kind[] METHOD_KINDS = PublicApiChecker.methodKinds();
    private static final String DEFAULT_FOR_CLASSES = "**";
    public static final String RULE_KEY = "UndocumentedApi";
    @RuleProperty(key="forClasses", defaultValue="**")
    public String forClasses = "**";
    private WildcardPattern[] patterns;
    private final Deque<ClassTree> classTrees = Lists.newLinkedList();
    private final Deque<Tree> currentParents = Lists.newLinkedList();
    private PublicApiChecker publicApiChecker;
    private String packageName;
    private final Pattern setterPattern = Pattern.compile("set[A-Z].*");
    private final Pattern getterPattern = Pattern.compile("(get|is)[A-Z].*");
    private JavaFileScannerContext context;
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"UndocumentedApi");

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.classTrees.clear();
        this.currentParents.clear();
        this.publicApiChecker = new PublicApiChecker();
        this.packageName = "";
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        if (tree.packageName() != null) {
            this.packageName = this.concatenate(tree.packageName());
        }
        super.visitCompilationUnit(tree);
    }

    public void visitNewClass(NewClassTree tree) {
    }

    public void visitClass(ClassTree tree) {
        this.visitNode((Tree)tree);
        super.visitClass(tree);
        this.classTrees.pop();
        this.currentParents.pop();
    }

    public void visitVariable(VariableTree tree) {
        this.visitNode((Tree)tree);
        super.visitVariable(tree);
    }

    public void visitMethod(MethodTree tree) {
        this.visitNode((Tree)tree);
        super.visitMethod(tree);
        this.currentParents.pop();
    }

    private void visitNode(Tree tree) {
        if (!this.isExcluded(tree)) {
            String javadoc = this.publicApiChecker.getApiJavadoc(tree);
            if (javadoc == null) {
                this.context.addIssue(tree, this.ruleKey, "Document this public " + this.getType(tree) + ".");
            } else if (!javadoc.contains("{@inheritDoc}")) {
                List<String> undocumentedParameters = this.getUndocumentedParameters(javadoc, this.getParameters(tree));
                if (!undocumentedParameters.isEmpty()) {
                    this.context.addIssue(tree, this.ruleKey, "Document the parameter(s): " + Joiner.on((String)", ").join(undocumentedParameters));
                }
                if (this.hasNonVoidReturnType(tree) && !this.hasReturnJavadoc(javadoc)) {
                    this.context.addIssue(tree, this.ruleKey, "Document this method return value.");
                }
            }
        }
    }

    private String getType(Tree tree) {
        String result = "";
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            result = "class";
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.INTERFACE})) {
            result = "interface";
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.ENUM})) {
            result = "enum";
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.ANNOTATION_TYPE})) {
            result = "annotation";
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
            result = "constructor";
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            result = "method";
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            result = "field";
        }
        return result;
    }

    private boolean isExcluded(Tree tree) {
        return !this.isPublicApi(tree) || this.isAccessor(tree) || !this.isMatchingPattern();
    }

    private boolean isAccessor(Tree tree) {
        if (!this.classTrees.isEmpty() && !this.classTrees.peek().is(new Tree.Kind[]{Tree.Kind.INTERFACE}) && tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            MethodTree methodTree = (MethodTree)tree;
            String name = methodTree.simpleName().name();
            return this.setterPattern.matcher(name).matches() && methodTree.parameters().size() == 1 || this.getterPattern.matcher(name).matches() && methodTree.parameters().isEmpty();
        }
        return false;
    }

    private boolean isPublicApi(Tree tree) {
        Tree currentParent = this.currentParents.peek();
        if (tree.is(CLASS_KINDS)) {
            this.classTrees.push((ClassTree)tree);
            this.currentParents.push(tree);
        } else if (tree.is(METHOD_KINDS)) {
            this.currentParents.push(tree);
        }
        return this.publicApiChecker.isPublicApi(currentParent, tree);
    }

    private boolean isMatchingPattern() {
        return WildcardPattern.match((WildcardPattern[])this.getPatterns(), (String)this.className());
    }

    private String className() {
        String className = this.packageName;
        IdentifierTree identifierTree = this.classTrees.peek().simpleName();
        if (identifierTree != null) {
            className = className + "/" + identifierTree.name();
        }
        return className;
    }

    private WildcardPattern[] getPatterns() {
        if (this.patterns == null) {
            this.patterns = PatternUtils.createPatterns(this.forClasses);
        }
        return this.patterns;
    }

    private List<String> getUndocumentedParameters(String javadoc, List<String> parameters) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String parameter : parameters) {
            if (UndocumentedApiCheck.hasParamJavadoc(javadoc, parameter)) continue;
            builder.add((Object)parameter);
        }
        return builder.build();
    }

    private List<String> getParameters(Tree tree) {
        ImmutableList.Builder builder;
        block3: {
            block2: {
                builder = ImmutableList.builder();
                if (!tree.is(METHOD_KINDS)) break block2;
                MethodTree methodTree = (MethodTree)tree;
                for (VariableTree variableTree : methodTree.parameters()) {
                    builder.add((Object)variableTree.simpleName().name());
                }
                break block3;
            }
            if (!tree.is(CLASS_KINDS)) break block3;
            for (TypeParameterTree typeParam : ((ClassTree)tree).typeParameters()) {
                builder.add((Object)("<" + typeParam.identifier().name() + ">"));
            }
        }
        return builder.build();
    }

    private static boolean hasParamJavadoc(String comment, String parameter) {
        return comment.matches("(?s).*@param\\s++" + parameter + ".*");
    }

    private boolean hasNonVoidReturnType(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD}) && !this.classTrees.peek().is(new Tree.Kind[]{Tree.Kind.ANNOTATION_TYPE})) {
            Tree returnType = ((MethodTree)tree).returnType();
            return returnType == null || !returnType.is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE}) || !"void".equals(((PrimitiveTypeTree)returnType).keyword().text());
        }
        return false;
    }

    private boolean hasReturnJavadoc(String comment) {
        return comment.contains("@return");
    }

    private String concatenate(ExpressionTree tree) {
        LinkedList<String> pieces = new LinkedList<String>();
        ExpressionTree expr = tree;
        while (expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
            pieces.push(mse.identifier().name());
            pieces.push("/");
            expr = mse.expression();
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree idt = (IdentifierTree)expr;
            pieces.push(idt.name());
        }
        StringBuilder sb = new StringBuilder();
        for (String piece : pieces) {
            sb.append(piece);
        }
        return sb.toString();
    }
}

