/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;

@Rule(key="S00119", priority=Priority.MAJOR, tags={"convention"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class BadTypeParameterName_S00119_Check
extends SubscriptionBaseVisitor {
    private static final String DEFAULT_FORMAT = "^[A-Z]$";
    @RuleProperty(key="format", defaultValue="^[A-Z]$")
    public String format = "^[A-Z]$";
    private Pattern pattern = null;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TYPE_PARAMETER);
    }

    public void scanFile(JavaFileScannerContext context) {
        this.pattern = Pattern.compile(this.format, 32);
        super.scanFile(context);
    }

    public void visitNode(Tree tree) {
        String name = ((TypeParameterTree)tree).identifier().name();
        if (!this.pattern.matcher(name).matches()) {
            this.addIssue(tree, "Rename this generic name to match the regular expression '" + this.format + "'.");
        }
    }
}

