/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S00108", priority=Priority.MAJOR, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class EmptyBlock_S00108_Check
extends SubscriptionBaseVisitor {
    private boolean isMethodBlock;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR, (Object)Tree.Kind.BLOCK, (Object)Tree.Kind.INITIALIZER, (Object)Tree.Kind.STATIC_INITIALIZER, (Object)Tree.Kind.SWITCH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.SWITCH_STATEMENT})) {
            SwitchStatementTree switchStatementTree = (SwitchStatementTree)tree;
            if (switchStatementTree.cases().isEmpty()) {
                this.addIssue((Tree)switchStatementTree, "Either remove or fill this block of code.");
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD}) || tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
            this.isMethodBlock = true;
        } else if (this.isMethodBlock) {
            this.isMethodBlock = false;
        } else if (!this.hasStatements((BlockTree)tree) && !this.hasCommentInside((BlockTree)tree)) {
            this.addIssue(tree, "Either remove or fill this block of code.");
        }
    }

    private boolean hasCommentInside(BlockTree tree) {
        return tree.closeBraceToken() == null || !tree.closeBraceToken().trivias().isEmpty();
    }

    private boolean hasStatements(BlockTree tree) {
        return !tree.body().isEmpty();
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD}) || tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
            this.isMethodBlock = false;
        }
    }
}

