/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

public abstract class AbstractInjectionChecker
extends SubscriptionBaseVisitor {
    protected String parameterName;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION);
    }

    protected boolean isDynamicString(Tree methodTree, ExpressionTree arg, @Nullable Symbol currentlyChecking) {
        return this.isDynamicString(methodTree, arg, currentlyChecking, false);
    }

    protected boolean isDynamicString(Tree methodTree, ExpressionTree arg, @Nullable Symbol currentlyChecking, boolean firstLevel) {
        if (arg.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return this.isIdentifierDynamicString(methodTree, (IdentifierTree)arg, currentlyChecking, firstLevel);
        }
        if (arg.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            BinaryExpressionTree binaryArg = (BinaryExpressionTree)arg;
            return this.isDynamicString(methodTree, binaryArg.rightOperand(), currentlyChecking) || this.isDynamicString(methodTree, binaryArg.leftOperand(), currentlyChecking);
        }
        if (arg.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return false;
        }
        return !arg.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL});
    }

    protected boolean isIdentifierDynamicString(Tree methodTree, IdentifierTree arg, @Nullable Symbol currentlyChecking, boolean firstLevel) {
        Tree argEnclosingDeclarationTree;
        Symbol symbol = this.getSemanticModel().getReference(arg);
        if (symbol.equals(currentlyChecking) || this.isConstant(symbol)) {
            return false;
        }
        Tree enclosingBlockTree = this.getSemanticModel().getTree(this.getSemanticModel().getEnv(methodTree));
        if (enclosingBlockTree.equals(argEnclosingDeclarationTree = this.getSemanticModel().getTree(this.getSemanticModel().getEnv(symbol)))) {
            VariableTree declaration = (VariableTree)this.getSemanticModel().getTree(symbol);
            if (declaration.initializer() != null && this.isDynamicString(methodTree, declaration.initializer(), currentlyChecking)) {
                return true;
            }
            Collection usages = this.getSemanticModel().getUsages(symbol);
            LocalVariableDynamicStringVisitor visitor = new LocalVariableDynamicStringVisitor(symbol, usages, methodTree);
            argEnclosingDeclarationTree.accept((TreeVisitor)visitor);
            return visitor.dynamicString;
        }
        this.parameterName = arg.name();
        return symbol.owner().isKind(16) && !firstLevel;
    }

    public boolean isConstant(Symbol symbol) {
        return symbol.isStatic() && symbol.isFinal();
    }

    protected void setParameterNameFromArgument(ExpressionTree arg) {
        if (arg.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.parameterName = ((IdentifierTree)arg).name();
        } else if (arg.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            this.parameterName = ((MemberSelectExpressionTree)arg).identifier().name();
        }
    }

    protected class LocalVariableDynamicStringVisitor
    extends BaseTreeVisitor {
        private final Collection<IdentifierTree> usages;
        private final Tree methodInvocationTree;
        private final Symbol currentlyChecking;
        boolean dynamicString;
        private boolean stopInspection;

        public LocalVariableDynamicStringVisitor(Symbol currentlyChecking, Collection<IdentifierTree> usages, Tree methodInvocationTree) {
            this.currentlyChecking = currentlyChecking;
            this.stopInspection = false;
            this.usages = usages;
            this.methodInvocationTree = methodInvocationTree;
            this.dynamicString = false;
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            if (!this.stopInspection && tree.variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && this.usages.contains(tree.variable())) {
                this.dynamicString |= AbstractInjectionChecker.this.isDynamicString(this.methodInvocationTree, tree.expression(), this.currentlyChecking);
            }
            super.visitAssignmentExpression(tree);
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (tree.equals(this.methodInvocationTree)) {
                this.stopInspection = true;
            } else {
                super.visitMethodInvocation(tree);
            }
        }

        public void visitNewClass(NewClassTree tree) {
            if (tree.equals(this.methodInvocationTree)) {
                this.stopInspection = true;
            } else {
                super.visitNewClass(tree);
            }
        }
    }
}

