/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2111", priority=Priority.CRITICAL, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class BigDecimalDoubleConstructorCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        NewClassTree nct;
        if (this.hasSemantic() && ((AbstractTypedTree)(nct = (NewClassTree)tree)).getSymbolType().is("java.math.BigDecimal") && this.isDoubleConstructor(nct)) {
            this.addIssue(tree, "Use \"BigDecimal.valueOf\" instead.");
        }
    }

    private boolean isDoubleConstructor(NewClassTree nct) {
        if (!nct.arguments().isEmpty() && nct.arguments().size() <= 2) {
            Type argumentType = ((AbstractTypedTree)nct.arguments().get(0)).getSymbolType();
            return argumentType.is("double") || argumentType.is("float");
        }
        return false;
    }
}

