/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1871", priority=Priority.MAJOR, tags={"bug"})
public class IdenticalCasesInSwitchCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.SWITCH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        SwitchStatementTree switchStatementTree = (SwitchStatementTree)tree;
        int index = 0;
        List cases = switchStatementTree.cases();
        HashSet reportedLabels = Sets.newHashSet();
        for (CaseGroupTree caseGroupTree : cases) {
            for (int i = ++index; i < cases.size(); ++i) {
                CaseLabelTree labelToReport;
                if (!SyntacticEquivalence.areEquivalent((List)caseGroupTree.body(), (List)((CaseGroupTree)cases.get(i)).body()) || reportedLabels.contains(labelToReport = this.getLastLabel((CaseGroupTree)cases.get(i)))) continue;
                reportedLabels.add(labelToReport);
                this.addIssue((Tree)labelToReport, "Either merge this case with the identical one on line \"" + ((JavaTree)this.getLastLabel(caseGroupTree)).getLine() + "\" or change one of the implementations.");
            }
        }
    }

    private CaseLabelTree getLastLabel(CaseGroupTree cases) {
        return (CaseLabelTree)cases.labels().get(cases.labels().size() - 1);
    }
}

