/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.model.expression.MethodInvocationTreeImpl;
import org.sonar.java.model.expression.NewClassTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2272", priority=Priority.MAJOR, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class IteratorNextExceptionCheck
extends SubscriptionBaseVisitor {
    private static final MethodInvocationMatcher NEXT_INVOCATION_MATCHER = MethodInvocationMatcher.create().typeDefinition("java.util.Iterator").name("next");

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTreeImpl methodTree = (MethodTreeImpl)tree;
        if (this.hasSemantic() && this.isIteratorNextMethod(methodTree.getSymbol()) && methodTree.block() != null) {
            NextMethodBodyVisitor visitor = new NextMethodBodyVisitor();
            tree.accept((TreeVisitor)visitor);
            if (!visitor.foundThrow) {
                this.addIssue(tree, "Add a \"NoSuchElementException\" for iteration beyond the end of the collection.");
            }
        }
    }

    private boolean isIteratorNextMethod(Symbol.MethodSymbol symbol) {
        return "next".equals(symbol.getName()) && symbol.getParametersTypes().isEmpty() && this.isIterator(symbol.enclosingClass());
    }

    private boolean isIterator(Symbol.TypeSymbol typeSymbol) {
        for (Type.ClassType superType : typeSymbol.superTypes()) {
            if (!superType.is("java.util.Iterator")) continue;
            return true;
        }
        return false;
    }

    private class NextMethodBodyVisitor
    extends BaseTreeVisitor {
        private boolean foundThrow = false;

        private NextMethodBodyVisitor() {
        }

        public void visitThrowStatement(ThrowStatementTree throwStatementTree) {
            NewClassTreeImpl newClassTree;
            ExpressionTree expression = throwStatementTree.expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && (newClassTree = (NewClassTreeImpl)expression).getSymbolType().is("java.util.NoSuchElementException")) {
                this.foundThrow = true;
            }
            super.visitThrowStatement(throwStatementTree);
        }

        public void visitMethodInvocation(MethodInvocationTree methodInvocation) {
            if (NEXT_INVOCATION_MATCHER.matches(methodInvocation, IteratorNextExceptionCheck.this.getSemanticModel()) || this.throwsNoSuchElementException(methodInvocation)) {
                this.foundThrow = true;
            }
            super.visitMethodInvocation(methodInvocation);
        }

        public boolean throwsNoSuchElementException(MethodInvocationTree methodInvocationTree) {
            MethodInvocationTreeImpl methodInvocationTreeImpl = (MethodInvocationTreeImpl)methodInvocationTree;
            Symbol symbol = methodInvocationTreeImpl.getSymbol();
            if (!symbol.isKind(16)) {
                return false;
            }
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
            if (methodSymbol.getThrownTypes() != null) {
                for (Symbol.TypeSymbol thrownType : methodSymbol.getThrownTypes()) {
                    if (!thrownType.getType().is("java.util.NoSuchElementException")) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

