/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2197", priority=Priority.CRITICAL)
public class ModulusEqualityCheck
extends SubscriptionBaseVisitor {
    private List<Symbol> methodParams = Lists.newArrayList();

    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        this.methodParams.clear();
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO})) {
            BinaryExpressionTree equality = (BinaryExpressionTree)tree;
            this.checkModulusAndIntLiteral(equality.leftOperand(), equality.rightOperand());
            this.checkModulusAndIntLiteral(equality.rightOperand(), equality.leftOperand());
        } else {
            MethodTree methodTree = (MethodTree)tree;
            for (VariableTree variableTree : methodTree.parameters()) {
                Symbol.VariableSymbol symbol = ((VariableTreeImpl)variableTree).getSymbol();
                this.methodParams.add((Symbol)symbol);
            }
        }
    }

    private void checkModulusAndIntLiteral(ExpressionTree operand1, ExpressionTree operand2) {
        if (operand1.is(new Tree.Kind[]{Tree.Kind.REMAINDER})) {
            boolean usesMethodParam;
            BinaryExpressionTree modulusExp = (BinaryExpressionTree)operand1;
            Integer intValue = LiteralUtils.intLiteralValue((ExpressionTree)operand2);
            boolean bl = usesMethodParam = this.isMethodParameter(modulusExp.leftOperand()) || this.isMethodParameter(modulusExp.rightOperand());
            if (intValue != null && intValue != 0 && usesMethodParam) {
                String sign = intValue > 0 ? "positive" : "negative";
                this.addIssue((Tree)operand1, "The results of this modulus operation may not be " + sign + ".");
            }
        }
    }

    private boolean isMethodParameter(ExpressionTree expressionTree) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree identifier = (IdentifierTree)expressionTree;
            Symbol symbol = this.getSemanticModel().getReference(identifier);
            return this.methodParams.contains(symbol);
        }
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)expressionTree;
            return this.isMethodParameter(memberSelectExpressionTree.expression());
        }
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)expressionTree;
            return this.isMethodParameter(methodInvocationTree.methodSelect());
        }
        return false;
    }
}

