/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2178", priority=Priority.CRITICAL, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class NonShortCircuitLogicCheck
extends SubscriptionBaseVisitor {
    private static final Map<String, String> REPLACEMENTS = ImmutableMap.of((Object)"&", (Object)"&&", (Object)"|", (Object)"||");

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.AND, (Object)Tree.Kind.OR);
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)tree;
        if (this.isBoolean(binaryExpressionTree.leftOperand())) {
            String operator = binaryExpressionTree.operatorToken().text();
            String replacement = REPLACEMENTS.get(operator);
            this.addIssue(tree, "Correct this \"" + operator + "\" to \"" + replacement + "\".");
        }
    }

    private boolean isBoolean(ExpressionTree expression) {
        AbstractTypedTree typedExpression = (AbstractTypedTree)expression;
        Type symbolType = typedExpression.getSymbolType();
        return symbolType.is("boolean") || symbolType.is("java.lang.Boolean");
    }
}

