/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2258", priority=Priority.BLOCKER, tags={"cwe", "owasp-top10", "security"})
public class NullCipherCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        if (((AbstractTypedTree)tree).getSymbolType().is("javax.crypto.NullCipher")) {
            this.addIssue(tree, "Remove this use of the \"NullCipher\" class.");
        }
    }
}

