/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1444", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class PublicStaticFieldShouldBeFinalCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1444";
    private JavaFileScannerContext context;
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1444");

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) || tree.is(new Tree.Kind[]{Tree.Kind.ENUM})) {
            for (Tree member : tree.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || !this.isPublicStaticNotFinal((VariableTree)member)) continue;
                this.context.addIssue(member, this.ruleKey, "Make this \"public static " + ((VariableTree)member).simpleName() + "\" field final");
            }
        }
        super.visitClass(tree);
    }

    private boolean isPublicStaticNotFinal(VariableTree tree) {
        boolean isPublic = false;
        boolean isStatic = false;
        boolean isFinal = false;
        for (Modifier modifier : tree.modifiers().modifiers()) {
            if (modifier == Modifier.PUBLIC) {
                isPublic = true;
                continue;
            }
            if (modifier == Modifier.STATIC) {
                isStatic = true;
                continue;
            }
            if (modifier != Modifier.FINAL) continue;
            isFinal = true;
        }
        return isPublic && isStatic && !isFinal;
    }
}

