/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1301", priority=Priority.MINOR, tags={"misra"})
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class SwitchAtLeastThreeCasesCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1301";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1301");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        int count = 0;
        for (CaseGroupTree caseGroup : tree.cases()) {
            count += caseGroup.labels().size();
        }
        if (count < 3) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Replace this \"switch\" statement by \"if\" statements to increase readability.");
        }
        super.visitSwitchStatement(tree);
    }
}

