/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractInSynchronizeChecker;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2276", priority=Priority.CRITICAL, tags={"bug", "multi-threading"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class ThreadSleepCheck
extends AbstractInSynchronizeChecker {
    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        if (this.isInSyncBlock()) {
            this.addIssue((Tree)mit, "Replace the call to \"Thread.sleep(...)\" with a call to \"wait(...)\".");
        }
    }

    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodInvocationMatcher.create().typeDefinition("java.lang.Thread").name("sleep").withNoParameterConstraint());
    }
}

