/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractInSynchronizeChecker;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2273", priority=Priority.CRITICAL, tags={"bug", "multi-threading"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class WaitInSynchronizeCheck
extends AbstractInSynchronizeChecker {
    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        if (!this.isInSyncBlock()) {
            String lockName;
            String methodName;
            if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree mse = (MemberSelectExpressionTree)mit.methodSelect();
                methodName = mse.identifier().name();
                lockName = ((AbstractTypedTree)mse.expression()).getSymbolType().getSymbol().getName();
            } else {
                methodName = ((IdentifierTree)mit.methodSelect()).name();
                lockName = "this";
            }
            this.addIssue((Tree)mit, "Make this call to \"" + methodName + "()\" only inside a synchronized block to be sure to hold the monitor on \"" + lockName + "\" object.");
        }
    }

    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.builder().add((Object)MethodInvocationMatcher.create().name("wait")).add((Object)MethodInvocationMatcher.create().name("wait").addParameter("long")).add((Object)MethodInvocationMatcher.create().name("wait").addParameter("long").addParameter("int")).add((Object)MethodInvocationMatcher.create().name("notify")).add((Object)MethodInvocationMatcher.create().name("notifyAll")).build();
    }
}

