/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public abstract class AbstractForLoopRule
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.FOR_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ForStatementTree forStatement = (ForStatementTree)tree;
        this.visitForStatement(forStatement);
    }

    public abstract void visitForStatement(ForStatementTree var1);

    @CheckForNull
    private static Integer minus(@Nullable Integer nullableInteger) {
        return nullableInteger == null ? null : Integer.valueOf(-nullableInteger.intValue());
    }

    protected static boolean isSameIdentifier(IdentifierTree identifier, ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree other = (IdentifierTree)expression;
            return other.name().equals(identifier.name());
        }
        return false;
    }

    protected static class ForLoopIncrement
    extends IntVariable {
        private final Integer value;

        public ForLoopIncrement(IdentifierTree identifier, @Nullable Integer value) {
            super(identifier);
            this.value = value;
        }

        public boolean hasValue() {
            return this.value != null;
        }

        public int value() {
            Preconditions.checkState((this.value != null ? 1 : 0) != 0, (Object)"This ForLoopIncrement has no value");
            return this.value;
        }

        @CheckForNull
        public static ForLoopIncrement findInUpdates(ForStatementTree forStatement) {
            ForLoopIncrement result = null;
            List updates = forStatement.update();
            if (updates.size() == 1) {
                ExpressionStatementTree statement = (ExpressionStatementTree)updates.get(0);
                ExpressionTree expression = statement.expression();
                if (expression.is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_INCREMENT})) {
                    UnaryExpressionTree unaryExp = (UnaryExpressionTree)expression;
                    result = ForLoopIncrement.increment(unaryExp.expression(), 1);
                } else if (expression.is(new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_DECREMENT})) {
                    UnaryExpressionTree unaryExp = (UnaryExpressionTree)expression;
                    result = ForLoopIncrement.increment(unaryExp.expression(), -1);
                } else if (expression.is(new Tree.Kind[]{Tree.Kind.PLUS_ASSIGNMENT})) {
                    AssignmentExpressionTree assignmentExp = (AssignmentExpressionTree)expression;
                    result = ForLoopIncrement.increment(assignmentExp.variable(), LiteralUtils.intLiteralValue((ExpressionTree)assignmentExp.expression()));
                } else if (expression.is(new Tree.Kind[]{Tree.Kind.MINUS_ASSIGNMENT})) {
                    AssignmentExpressionTree assignmentExp = (AssignmentExpressionTree)expression;
                    result = ForLoopIncrement.increment(assignmentExp.variable(), AbstractForLoopRule.minus(LiteralUtils.intLiteralValue((ExpressionTree)assignmentExp.expression())));
                } else if (expression.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
                    AssignmentExpressionTree assignment = (AssignmentExpressionTree)expression;
                    result = ForLoopIncrement.assignmentIncrement(assignment);
                }
            }
            return result;
        }

        @CheckForNull
        private static ForLoopIncrement increment(ExpressionTree expression, Integer value) {
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return new ForLoopIncrement((IdentifierTree)expression, value);
            }
            return null;
        }

        private static ForLoopIncrement assignmentIncrement(AssignmentExpressionTree assignmentExpression) {
            ExpressionTree expression = assignmentExpression.expression();
            ExpressionTree variable = assignmentExpression.variable();
            if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && expression.is(new Tree.Kind[]{Tree.Kind.PLUS, Tree.Kind.MINUS})) {
                BinaryExpressionTree binaryExp = (BinaryExpressionTree)expression;
                Integer increment = LiteralUtils.intLiteralValue((ExpressionTree)binaryExp.rightOperand());
                if (increment != null && AbstractForLoopRule.isSameIdentifier((IdentifierTree)variable, binaryExp.leftOperand())) {
                    increment = expression.is(new Tree.Kind[]{Tree.Kind.MINUS}) ? AbstractForLoopRule.minus(increment) : increment;
                    return ForLoopIncrement.increment(variable, increment);
                }
                return new ForLoopIncrement((IdentifierTree)variable, null);
            }
            return null;
        }
    }

    protected static class ForLoopInitializer
    extends IntVariable {
        private final Integer value;

        public ForLoopInitializer(IdentifierTree identifier, @Nullable Integer value) {
            super(identifier);
            this.value = value;
        }

        @CheckForNull
        public Integer value() {
            return this.value;
        }

        public static Iterable<ForLoopInitializer> list(ForStatementTree forStatement) {
            ArrayList list = Lists.newArrayList();
            for (StatementTree statement : forStatement.initializer()) {
                ExpressionTree expression;
                Object initializer;
                if (statement.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                    VariableTree variable = (VariableTree)statement;
                    initializer = variable.initializer();
                    Integer value = initializer == null ? null : LiteralUtils.intLiteralValue((ExpressionTree)initializer);
                    list.add(new ForLoopInitializer(variable.simpleName(), value));
                }
                if (!statement.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) || (initializer = ForLoopInitializer.assignmentInitializer(expression = ((ExpressionStatementTree)statement).expression())) == null) continue;
                list.add(initializer);
            }
            return list;
        }

        private static ForLoopInitializer assignmentInitializer(ExpressionTree expression) {
            if (expression.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
                AssignmentExpressionTree assignment = (AssignmentExpressionTree)expression;
                ExpressionTree variable = assignment.variable();
                if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                    return new ForLoopInitializer((IdentifierTree)variable, LiteralUtils.intLiteralValue((ExpressionTree)assignment.expression()));
                }
            }
            return null;
        }
    }

    protected static class IntVariable {
        private final IdentifierTree identifier;

        public IntVariable(IdentifierTree identifier) {
            this.identifier = identifier;
        }

        public boolean hasSameIdentifier(ExpressionTree expression) {
            return AbstractForLoopRule.isSameIdentifier(this.identifier, expression);
        }

        public IdentifierTree identifier() {
            return this.identifier;
        }
    }
}

