/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.java.model.expression.MethodInvocationTreeImpl;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2116", priority=Priority.CRITICAL, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class ArrayHashCodeAndToStringCheck
extends AbstractMethodDetection {
    private static final TypeCriteria IS_ARRAY = new IsArrayCriteria();

    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)this.arrayMethodInvocation("toString"), (Object)this.arrayMethodInvocation("hashCode"));
    }

    private MethodInvocationMatcher arrayMethodInvocation(String methodName) {
        return MethodInvocationMatcher.create().callSite(IS_ARRAY).name(methodName);
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        MethodInvocationTreeImpl methodInvocationTreeImpl = (MethodInvocationTreeImpl)mit;
        String methodName = methodInvocationTreeImpl.getSymbol().getName();
        this.addIssue((Tree)mit, "Use \"Arrays." + methodName + "(array)\" instead.");
    }

    private static class IsArrayCriteria
    extends TypeCriteria {
        private IsArrayCriteria() {
        }

        @Override
        public boolean matches(Type type) {
            return type.isTagged(11);
        }
    }
}

