/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2278", priority=Priority.CRITICAL, tags={"cwe", "owasp-top10", "security"})
public class AvoidDESCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodInvocationMatcher.create().typeDefinition("javax.crypto.Cipher").name("getInstance").withNoParameterConstraint());
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        String tranformation;
        String[] transformationElements;
        ExpressionTree firstArg = (ExpressionTree)mit.arguments().get(0);
        if (firstArg.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && (transformationElements = (tranformation = this.trimQuotes(((LiteralTree)firstArg).value())).split("/")).length > 0 && this.isExcludedAlgorithm(transformationElements[0])) {
            this.addIssue((Tree)mit, "Use the recommended AES (Advanced Encryption Standard) instead.");
        }
    }

    private boolean isExcludedAlgorithm(String algorithm) {
        return "DES".equals(algorithm) || "DESede".equals(algorithm);
    }

    private String trimQuotes(String value) {
        return value.substring(1, value.length() - 1);
    }
}

