/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.regex.Pattern;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S00115", priority=Priority.MAJOR, tags={"convention"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class BadConstantName_S00115_Check
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S00115";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S00115");
    private static final String DEFAULT_FORMAT = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";
    @RuleProperty(key="format", defaultValue="^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$")
    public String format = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";
    private Pattern pattern = null;
    private JavaFileScannerContext context;
    private SemanticModel semanticModel;

    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        this.context = context;
        this.semanticModel = (SemanticModel)context.getSemanticModel();
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        for (Tree member : tree.members()) {
            if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && this.semanticModel != null) {
                VariableTree variableTree = (VariableTree)member;
                Type symbolType = ((VariableTreeImpl)variableTree).getSymbol().getType();
                if (!this.isConstantType(symbolType) || !tree.is(new Tree.Kind[]{Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE}) && !this.isStaticFinal(variableTree)) continue;
                this.checkName(variableTree);
                continue;
            }
            if (!member.is(new Tree.Kind[]{Tree.Kind.ENUM_CONSTANT})) continue;
            this.checkName((VariableTree)member);
        }
        super.visitClass(tree);
    }

    private boolean isConstantType(Type symbolType) {
        return symbolType.isPrimitive() || symbolType.is("java.lang.String") || symbolType.isPrimitiveWrapper();
    }

    private void checkName(VariableTree variableTree) {
        if (!"serialVersionUID".equals(variableTree.simpleName().name()) && !this.pattern.matcher(variableTree.simpleName().name()).matches()) {
            this.context.addIssue((Tree)variableTree, this.ruleKey, "Rename this constant name to match the regular expression '" + this.format + "'.");
        }
    }

    private boolean isStaticFinal(VariableTree variableTree) {
        boolean isStatic = false;
        boolean isFinal = false;
        for (Modifier modifier : variableTree.modifiers().modifiers()) {
            if (modifier == Modifier.STATIC) {
                isStatic = true;
            }
            if (modifier != Modifier.FINAL) continue;
            isFinal = true;
        }
        return isStatic && isFinal;
    }
}

