/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2166", priority=Priority.MAJOR, tags={"convention", "pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ClassNamedLikeExceptionCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTreeImpl classTree;
        Symbol.TypeSymbol symbol;
        String className;
        if (this.hasSemantic() && (className = (symbol = (classTree = (ClassTreeImpl)tree).getSymbol()).getName()).toLowerCase().endsWith("exception") && !symbol.getType().isSubtypeOf("java.lang.Exception")) {
            String suffix = className.substring(className.length() - "exception".length());
            this.addIssue((Tree)classTree, "Rename this class to remove \"" + suffix + "\" or correct its inheritance.");
        }
    }
}

