/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2157", priority=Priority.CRITICAL, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class CloneableImplementingCloneCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTreeImpl classTree = (ClassTreeImpl)tree;
        Symbol.TypeSymbol classSymbol = classTree.getSymbol();
        if (this.isCloneable(classTree) && !classSymbol.isAbstract() && !this.declaresCloneMethod(classSymbol)) {
            this.addIssue(tree, "Add a \"clone()\" method to this class.");
        }
    }

    private boolean declaresCloneMethod(Symbol.TypeSymbol classSymbol) {
        for (Symbol memberSymbol : classSymbol.members().lookup("clone")) {
            Symbol.MethodSymbol methodSymbol;
            if (!memberSymbol.isKind(16) || !(methodSymbol = (Symbol.MethodSymbol)memberSymbol).getParametersTypes().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean isCloneable(ClassTreeImpl classTree) {
        for (Tree superInterface : classTree.superInterfaces()) {
            AbstractTypedTree typedInterface = (AbstractTypedTree)superInterface;
            if (!typedInterface.getSymbolType().is("java.lang.Cloneable")) continue;
            return true;
        }
        return false;
    }
}

