/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2257", priority=Priority.BLOCKER, tags={"cwe", "owasp-top10", "sans-top25", "security"})
public class CustomCryptographicAlgorithmCheck
extends SubscriptionBaseVisitor {
    private static final String MESSAGE_DIGEST_QUALIFIED_NAME = "java.security.MessageDigest";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic() && this.isJavaSecurityMessageDigestSubClass((ClassTreeImpl)tree)) {
            this.addIssue(tree, "Use a standard algorithm instead of creating a custom one.");
        }
    }

    private boolean isJavaSecurityMessageDigestSubClass(ClassTreeImpl tree) {
        Symbol.TypeSymbol classSymbol = tree.getSymbol();
        return classSymbol != null && !classSymbol.getType().is(MESSAGE_DIGEST_QUALIFIED_NAME) && classSymbol.getType().isSubtypeOf(MESSAGE_DIGEST_QUALIFIED_NAME);
    }
}

