/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.java.model.expression.AssignmentExpressionTreeImpl;
import org.sonar.java.model.expression.MethodInvocationTreeImpl;
import org.sonar.java.model.expression.NewClassTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2153", priority=Priority.MAJOR, tags={"clumsy"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ImmediateReverseBoxingCheck
extends SubscriptionBaseVisitor {
    private static final Map<String, String> PRIMITIVE_TYPES_BY_WRAPPER = ImmutableMap.builder().put((Object)"java.lang.Boolean", (Object)"boolean").put((Object)"java.lang.Byte", (Object)"byte").put((Object)"java.lang.Double", (Object)"double").put((Object)"java.lang.Float", (Object)"float").put((Object)"java.lang.Integer", (Object)"int").put((Object)"java.lang.Long", (Object)"long").put((Object)"java.lang.Short", (Object)"short").build();
    private final List<MethodInvocationMatcher> unboxingInvocationMatchers = this.unboxingInvocationMatchers();
    private final List<MethodInvocationMatcher> valueOfInvocationMatchers = this.valueOfInvocationMatchers();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.ASSIGNMENT, (Object)Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                this.visitMethodInvocationTree((MethodInvocationTreeImpl)tree);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                VariableTreeImpl variableTree = (VariableTreeImpl)tree;
                ExpressionTree initializer = variableTree.initializer();
                if (initializer != null) {
                    this.checkExpression(initializer, variableTree.getSymbol().getType());
                }
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
                AssignmentExpressionTreeImpl assignmentTree = (AssignmentExpressionTreeImpl)tree;
                this.checkExpression(assignmentTree.expression(), assignmentTree.getSymbolType());
            } else {
                NewClassTreeImpl newClassTree = (NewClassTreeImpl)tree;
                Symbol.TypeSymbol classSymbol = this.wrapperClassSymbol(newClassTree);
                if (classSymbol != null) {
                    this.checkForUnboxing((ExpressionTree)newClassTree.arguments().get(0));
                }
            }
        }
    }

    private void checkExpression(ExpressionTree expression, Type implicitType) {
        if (implicitType.isPrimitive()) {
            this.checkForBoxing(expression);
        } else {
            this.checkForUnboxing(expression);
        }
    }

    private void visitMethodInvocationTree(MethodInvocationTreeImpl methodInvocationTree) {
        if (this.isValueOfInvocation(methodInvocationTree)) {
            this.checkForUnboxing((ExpressionTree)methodInvocationTree.arguments().get(0));
        } else if (this.isUnboxingMethodInvocation(methodInvocationTree)) {
            ExpressionTree methodSelect = methodInvocationTree.methodSelect();
            if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)methodSelect;
                this.checkForBoxing(memberSelectExpressionTree.expression());
            }
        } else {
            Symbol symbol = methodInvocationTree.getSymbol();
            if (symbol.isKind(16)) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
                List parametersTypes = methodSymbol.getParametersTypes();
                this.checkMethodInvocationArguments(methodInvocationTree, parametersTypes);
            }
        }
    }

    private void checkMethodInvocationArguments(MethodInvocationTreeImpl methodInvocationTree, List<Type> parametersTypes) {
        List arguments = methodInvocationTree.arguments();
        int position = 0;
        for (Type paramType : parametersTypes) {
            if (arguments.size() > position) {
                this.checkExpression((ExpressionTree)arguments.get(position), paramType);
            }
            ++position;
        }
    }

    private void checkForBoxing(ExpressionTree expression) {
        MethodInvocationTreeImpl methodInvocationTree;
        if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            AbstractTypedTree boxingArg;
            NewClassTreeImpl newClassTree = (NewClassTreeImpl)expression;
            Symbol.TypeSymbol classSymbol = this.wrapperClassSymbol(newClassTree);
            if (classSymbol != null && (boxingArg = (AbstractTypedTree)newClassTree.arguments().get(0)).getSymbolType().isPrimitive()) {
                this.addBoxingIssue((Tree)newClassTree, (Symbol)classSymbol, (Tree)boxingArg);
            }
        } else if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && this.isValueOfInvocation(methodInvocationTree = (MethodInvocationTreeImpl)expression)) {
            ExpressionTree boxingArg = (ExpressionTree)methodInvocationTree.arguments().get(0);
            this.addBoxingIssue((Tree)expression, methodInvocationTree.getSymbol().owner(), (Tree)boxingArg);
        }
    }

    private Symbol.TypeSymbol wrapperClassSymbol(NewClassTreeImpl newClassTree) {
        Symbol.TypeSymbol classSymbol = newClassTree.getSymbolType().getSymbol();
        String fullyQualifiedName = classSymbol.getFullyQualifiedName();
        if (PRIMITIVE_TYPES_BY_WRAPPER.containsKey(fullyQualifiedName)) {
            return classSymbol;
        }
        return null;
    }

    private void addBoxingIssue(Tree tree, Symbol classSymbol, Tree boxingArg) {
        if (boxingArg.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree identifier = (IdentifierTree)boxingArg;
            this.addIssue(tree, "Remove the boxing of \"" + identifier.name() + "\".");
        } else {
            this.addIssue(tree, "Remove the boxing to \"" + classSymbol.getName() + "\".");
        }
    }

    private void checkForUnboxing(ExpressionTree expressionTree) {
        if (!expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return;
        }
        MethodInvocationTreeImpl methodInvocationTree = (MethodInvocationTreeImpl)expressionTree;
        if (this.isUnboxingMethodInvocation(methodInvocationTree)) {
            ExpressionTree methodSelect = methodInvocationTree.methodSelect();
            if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)methodSelect;
                AbstractTypedTree unboxedExpression = (AbstractTypedTree)memberSelectExpressionTree.expression();
                Type unboxedExpressionType = unboxedExpression.getSymbolType();
                String unboxingResultTypeName = methodInvocationTree.getSymbolType().getSymbol().getFullyQualifiedName();
                if (unboxingResultTypeName.equals(PRIMITIVE_TYPES_BY_WRAPPER.get(unboxedExpressionType.getSymbol().getFullyQualifiedName()))) {
                    this.addUnboxingIssue(expressionTree, unboxedExpression);
                }
            }
        }
    }

    private void addUnboxingIssue(ExpressionTree expressionTree, AbstractTypedTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree identifier = (IdentifierTree)expression;
            this.addIssue((Tree)expressionTree, "Remove the unboxing of \"" + identifier.name() + "\".");
        } else {
            String name = expression.getSymbolType().getSymbol().getName();
            this.addIssue((Tree)expressionTree, "Remove the unboxing from \"" + name + "\".");
        }
    }

    private List<MethodInvocationMatcher> unboxingInvocationMatchers() {
        ArrayList matchers = Lists.newArrayList();
        for (String primitiveType : PRIMITIVE_TYPES_BY_WRAPPER.values()) {
            matchers.add(MethodInvocationMatcher.create().callSite("boolean".equals(primitiveType) ? TypeCriteria.is("java.lang.Boolean") : TypeCriteria.subtypeOf("java.lang.Number")).name(primitiveType + "Value"));
        }
        return matchers;
    }

    private List<MethodInvocationMatcher> valueOfInvocationMatchers() {
        ArrayList matchers = Lists.newArrayList();
        for (Map.Entry<String, String> primitiveMapping : PRIMITIVE_TYPES_BY_WRAPPER.entrySet()) {
            matchers.add(MethodInvocationMatcher.create().typeDefinition(primitiveMapping.getKey()).name("valueOf").addParameter(primitiveMapping.getValue()));
        }
        return matchers;
    }

    private boolean isUnboxingMethodInvocation(MethodInvocationTreeImpl methodInvocationTree) {
        return this.matchesMethodInvocation(methodInvocationTree, this.unboxingInvocationMatchers);
    }

    private boolean isValueOfInvocation(MethodInvocationTreeImpl methodInvocationTree) {
        return this.matchesMethodInvocation(methodInvocationTree, this.valueOfInvocationMatchers);
    }

    private boolean matchesMethodInvocation(MethodInvocationTreeImpl methodInvocationTree, List<MethodInvocationMatcher> matchers) {
        for (MethodInvocationMatcher methodInvocationMatcher : matchers) {
            if (!methodInvocationMatcher.matches((MethodInvocationTree)methodInvocationTree, this.getSemanticModel())) continue;
            return true;
        }
        return false;
    }
}

