/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2176", priority=Priority.MAJOR, tags={"pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class InterfaceOrSuperclassShadowingCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.INTERFACE);
    }

    public void visitNode(Tree tree) {
        ClassTreeImpl classTree = (ClassTreeImpl)tree;
        if (this.hasSemantic()) {
            Symbol.TypeSymbol classSymbol = classTree.getSymbol();
            this.checkSuperType(classTree, classSymbol.getSuperclass());
            for (Type interfaceType : classSymbol.getInterfaces()) {
                this.checkSuperType(classTree, interfaceType);
            }
        }
    }

    private void checkSuperType(ClassTreeImpl tree, Type superType) {
        if (superType != null && superType.getSymbol().getName().equals(tree.getSymbol().getName())) {
            String classOrInterface = tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) ? "class" : "interface";
            this.addIssue((Tree)tree, "Rename this " + classOrInterface + ".");
        }
    }
}

