/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2127", priority=Priority.BLOCKER, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.BLOCKER)
public class LongBitsToDoubleOnIntCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.builder().add((Object)MethodInvocationMatcher.create().typeDefinition("java.lang.Double").name("longBitsToDouble").addParameter("long")).build();
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        Type symbolType = ((AbstractTypedTree)mit.arguments().get(0)).getSymbolType();
        if (!symbolType.is("long") && !symbolType.is("java.lang.Long")) {
            this.addIssue((Tree)mit, "Remove this \"Double.longBitsToDouble\" call.");
        }
    }
}

