/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.expression.BinaryExpressionTreeImpl;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2164", priority=Priority.CRITICAL, tags={"bug"})
public class MathOnFloatCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S2164";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S2164");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        BinaryExpressionTreeImpl expressionTree;
        if (tree.is(new Tree.Kind[]{Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE}) && (expressionTree = (BinaryExpressionTreeImpl)tree).getSymbolType().is("float")) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Use a \"double\" or \"BigDecimal\" instead.");
            return;
        }
        super.visitBinaryExpression(tree);
    }
}

