/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1221", priority=Priority.CRITICAL, tags={"pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class MethodNamedHashcodeCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if ("hashcode".equals(((MethodTree)tree).simpleName().name())) {
            this.addIssue((Tree)((MethodTree)tree).simpleName(), "Either override Object.hashCode(), or totally rename the method to prevent any confusion.");
        }
    }
}

