/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1142", priority=Priority.MAJOR, tags={"brain-overload"})
public class MethodWithExcessiveReturnsCheck
extends SubscriptionBaseVisitor {
    private static final int DEFAULT_MAX = 3;
    @RuleProperty(defaultValue="3")
    public int max = 3;
    private final Multiset<Tree> returnStatementCounter = HashMultiset.create();
    private final Deque<Tree> methods = new LinkedList<Tree>();

    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        this.returnStatementCounter.clear();
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.RETURN_STATEMENT, (Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            this.returnStatementCounter.add((Object)this.methods.peek());
        } else {
            this.methods.push(tree);
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            int count = this.returnStatementCounter.count((Object)tree);
            if (count > this.max) {
                this.addIssue(tree, "Reduce the number of returns of this method " + count + ", down to the maximum allowed " + this.max + ".");
            }
            this.methods.pop();
        }
    }
}

