/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Sets;
import java.util.Set;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1226", priority=Priority.MAJOR, tags={"pitfall", "misra"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ParameterReassignedToCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1226";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1226");
    private final Set<Symbol.VariableSymbol> variables = Sets.newHashSet();
    private JavaFileScannerContext context;
    private SemanticModel semanticModel;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.variables.clear();
        this.semanticModel = (SemanticModel)context.getSemanticModel();
        this.scan((Tree)context.getTree());
    }

    private boolean hasSemanticModel() {
        return this.semanticModel != null;
    }

    public void visitMethod(MethodTree tree) {
        for (VariableTree parameterTree : tree.parameters()) {
            this.variables.add(((VariableTreeImpl)parameterTree).getSymbol());
        }
        super.visitMethod(tree);
        for (VariableTree parameterTree : tree.parameters()) {
            this.variables.remove(((VariableTreeImpl)parameterTree).getSymbol());
        }
    }

    public void visitCatch(CatchTree tree) {
        this.variables.add(((VariableTreeImpl)tree.parameter()).getSymbol());
        super.visitCatch(tree);
        this.variables.remove(((VariableTreeImpl)tree.parameter()).getSymbol());
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        this.checkExpression(tree.variable());
    }

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (ParameterReassignedToCheck.isIncrementOrDecrement((Tree)tree) && tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.checkExpression(tree.expression());
        }
    }

    private static boolean isIncrementOrDecrement(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.PREFIX_INCREMENT}) || tree.is(new Tree.Kind[]{Tree.Kind.PREFIX_DECREMENT}) || tree.is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT}) || tree.is(new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT});
    }

    private void checkExpression(ExpressionTree tree) {
        IdentifierTree identifier;
        Symbol reference;
        if (this.hasSemanticModel() && tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (reference = this.semanticModel.getReference(identifier = (IdentifierTree)tree)) != null && reference.isKind(4) && this.variables.contains(reference)) {
            this.context.addIssue((Tree)identifier, this.ruleKey, "Introduce a new variable instead of reusing the parameter \"" + identifier.name() + "\".");
        }
    }
}

