/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2275", priority=Priority.CRITICAL, tags={"bug", "pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class PrintfCheck
extends AbstractMethodDetection {
    private static final Pattern PRINTF_PARAM_PATTERN = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private static final Set<String> TIME_CONVERSIONS = Sets.newHashSet((Object[])new String[]{"H", "I", "k", "l", "M", "S", "L", "N", "p", "z", "Z", "s", "Q", "B", "b", "h", "A", "a", "C", "Y", "y", "j", "m", "d", "e", "R", "T", "r", "D", "F", "c"});
    private static final String FORMAT_METHOD_NAME = "format";

    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodInvocationMatcher.create().typeDefinition("java.lang.String").name(FORMAT_METHOD_NAME).withNoParameterConstraint(), (Object)MethodInvocationMatcher.create().typeDefinition("java.util.Formatter").name(FORMAT_METHOD_NAME).withNoParameterConstraint(), (Object)MethodInvocationMatcher.create().typeDefinition("java.io.PrintStream").name(FORMAT_METHOD_NAME).withNoParameterConstraint(), (Object)MethodInvocationMatcher.create().typeDefinition("java.io.PrintStream").name("printf").withNoParameterConstraint(), (Object)MethodInvocationMatcher.create().typeDefinition("java.io.PrintWriter").name(FORMAT_METHOD_NAME).withNoParameterConstraint(), (Object)MethodInvocationMatcher.create().typeDefinition("java.io.PrintWriter").name("printf").withNoParameterConstraint());
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        List<ExpressionTree> args;
        ExpressionTree formatStringTree;
        if (((AbstractTypedTree)mit.arguments().get(0)).getSymbolType().is("java.lang.String")) {
            formatStringTree = (ExpressionTree)mit.arguments().get(0);
            args = mit.arguments().subList(1, mit.arguments().size());
        } else {
            formatStringTree = (ExpressionTree)mit.arguments().get(1);
            args = mit.arguments().subList(2, mit.arguments().size());
        }
        if (formatStringTree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            String formatString = this.trimQuotes(((LiteralTree)formatStringTree).value());
            this.checkLineFeed(formatString, mit);
            List<String> params = this.getParameters(formatString, mit);
            if (this.usesMessageFormat(formatString, params)) {
                this.addIssue((Tree)mit, "Looks like there is a confusion with the use of java.text.MessageFormat, parameters will be simply ignored here");
                return;
            }
            this.cleanupLineSeparator(params);
            if (params.size() > args.size()) {
                this.addIssue((Tree)mit, "Not enough arguments.");
                return;
            }
            this.verifyParameters(mit, args, params);
        }
    }

    private void cleanupLineSeparator(List<String> params) {
        Iterator<String> iter = params.iterator();
        while (iter.hasNext()) {
            String param = iter.next();
            if (!"n".equals(param) && !"%".equals(param)) continue;
            iter.remove();
        }
    }

    private void checkLineFeed(String formatString, MethodInvocationTree mit) {
        if (formatString.contains("\\n")) {
            this.addIssue((Tree)mit, "%n should be used in place of \\n to produce the platform-specific line separator.");
        }
    }

    private void verifyParameters(MethodInvocationTree mit, List<ExpressionTree> args, List<String> params) {
        int index = 0;
        ArrayList unusedArgs = Lists.newArrayList(args);
        Iterator<String> i$ = params.iterator();
        while (i$.hasNext()) {
            String rawParam;
            String param = rawParam = i$.next();
            int argIndex = index++;
            if (param.contains("$")) {
                argIndex = Integer.valueOf(param.substring(0, param.indexOf("$"))) - 1;
                param = param.substring(param.indexOf("$") + 1);
            }
            ExpressionTree argExpressionTree = args.get(argIndex);
            unusedArgs.remove(argExpressionTree);
            Type argType = ((AbstractTypedTree)argExpressionTree).getSymbolType();
            if (param.startsWith("d") && !this.isNumerical(argType)) {
                this.addIssue((Tree)mit, "An 'int' is expected rather than a " + argType + ".");
            }
            if (param.startsWith("b") && !argType.is("boolean") && !argType.is("java.lang.Boolean")) {
                this.addIssue((Tree)mit, "Directly inject the boolean value.");
            }
            this.checkTimeConversion(mit, param, argType);
        }
        this.reportUnusedArgs(mit, args, unusedArgs);
    }

    private void checkTimeConversion(MethodInvocationTree mit, String param, Type argType) {
        if (param.startsWith("t") || param.startsWith("T")) {
            String timeConversion = param.substring(1);
            if (timeConversion.isEmpty()) {
                this.addIssue((Tree)mit, "Time conversion requires a second character.");
                this.checkTimeTypeArgument(mit, argType);
                return;
            }
            if (!TIME_CONVERSIONS.contains(timeConversion)) {
                this.addIssue((Tree)mit, timeConversion + " is not a supported time conversion character");
            }
            this.checkTimeTypeArgument(mit, argType);
        }
    }

    private void checkTimeTypeArgument(MethodInvocationTree mit, Type argType) {
        if (!(argType.isNumerical() || argType.is("java.lang.Long") || argType.isSubtypeOf("java.util.Date") || argType.isSubtypeOf("java.util.Calendar"))) {
            this.addIssue((Tree)mit, "Time argument is expected (long, Long, Date or Calendar).");
        }
    }

    private boolean isNumerical(Type argType) {
        return argType.isNumerical() || argType.is("java.math.BigInteger") || argType.is("java.math.BigDecimal") || argType.is("java.lang.Byte") || argType.is("java.lang.Short") || argType.is("java.lang.Integer") || argType.is("java.lang.Long") || argType.is("java.lang.Float") || argType.is("java.lang.Double");
    }

    private boolean usesMessageFormat(String formatString, List<String> params) {
        return params.isEmpty() && (formatString.contains("{0") || formatString.contains("{1"));
    }

    private void reportUnusedArgs(MethodInvocationTree mit, List<ExpressionTree> args, List<ExpressionTree> unusedArgs) {
        for (ExpressionTree unusedArg : unusedArgs) {
            int i = args.indexOf(unusedArg);
            String stringArgIndex = "first";
            if (i == 1) {
                stringArgIndex = "2nd";
            } else if (i == 2) {
                stringArgIndex = "3rd";
            } else if (i >= 3) {
                stringArgIndex = i + 1 + "th";
            }
            this.addIssue((Tree)mit, stringArgIndex + " argument is not used.");
        }
    }

    private List<String> getParameters(String formatString, MethodInvocationTree mit) {
        ArrayList params = Lists.newArrayList();
        Matcher matcher = PRINTF_PARAM_PATTERN.matcher(formatString);
        while (matcher.find()) {
            if (this.firstArgumentIsLT(params, matcher.group(2))) {
                this.addIssue((Tree)mit, "The argument index '<' refers to the previous format specifier but there isn't one.");
                continue;
            }
            StringBuilder param = new StringBuilder();
            for (int groupIndex : new int[]{1, 5, 6}) {
                if (matcher.group(groupIndex) == null) continue;
                param.append(matcher.group(groupIndex));
            }
            params.add(param.toString());
        }
        return params;
    }

    private boolean firstArgumentIsLT(List<String> params, @Nullable String group) {
        return params.isEmpty() && group != null && group.startsWith("<");
    }

    private String trimQuotes(String value) {
        return value.substring(1, value.length() - 1);
    }
}

