/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2333", priority=Priority.MINOR, tags={"clumsy"})
public class RedundantModifierCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.ANNOTATION_TYPE, (Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        for (Tree member : classTree.members()) {
            ModifiersTree modifiers;
            if (member.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
                MethodTree methodTree = (MethodTree)member;
                modifiers = methodTree.modifiers();
                if (this.isInterfaceOrAnnotation(tree)) {
                    this.checkRedundantModifier(modifiers, Modifier.ABSTRACT);
                    this.checkRedundantModifier(modifiers, Modifier.PUBLIC);
                    continue;
                }
                if (!classTree.modifiers().modifiers().contains(Modifier.FINAL)) continue;
                this.checkRedundantModifier(modifiers, Modifier.FINAL);
                continue;
            }
            if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || !this.isInterfaceOrAnnotation(tree)) continue;
            VariableTree variableTree = (VariableTree)member;
            modifiers = variableTree.modifiers();
            this.checkRedundantModifier(modifiers, Modifier.PUBLIC);
            this.checkRedundantModifier(modifiers, Modifier.STATIC);
            this.checkRedundantModifier(modifiers, Modifier.FINAL);
        }
    }

    private boolean isInterfaceOrAnnotation(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE});
    }

    private void checkRedundantModifier(ModifiersTree modifiersTree, Modifier modifier) {
        if (modifiersTree.modifiers().contains(modifier)) {
            this.addIssue((Tree)modifiersTree, "\"" + modifier.toString().toLowerCase() + "\" is redundant in this context.");
        }
    }
}

