/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.AnnotationValue;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2109", priority=Priority.BLOCKER, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.BLOCKER)
public class ReflectionOnNonRuntimeAnnotationCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodInvocationMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.lang.reflect.AnnotatedElement")).name("isAnnotationPresent").withNoParameterConstraint());
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        Type symbolType;
        ExpressionTree expressionTree = (ExpressionTree)mit.arguments().get(0);
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && this.isNotRuntimeAnnotation(symbolType = ((AbstractTypedTree)((MemberSelectExpressionTree)expressionTree).expression()).getSymbolType())) {
            this.addIssue((Tree)mit, "\"@" + symbolType.getSymbol().getName() + "\" is not available at runtime and cannot be seen with reflection.");
        }
    }

    private boolean isNotRuntimeAnnotation(Type symbolType) {
        List valuesFor = symbolType.getSymbol().metadata().getValuesFor("java.lang.annotation.Retention");
        return valuesFor == null || !"RUNTIME".equals(((Symbol.VariableSymbol)((AnnotationValue)valuesFor.get(0)).value()).getName());
    }
}

