/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.model.expression.MethodInvocationTreeImpl;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2151", priority=Priority.BLOCKER, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.BLOCKER)
public class RunFinalizersCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.builder().add((Object)MethodInvocationMatcher.create().typeDefinition("java.lang.Runtime").name("runFinalizersOnExit").addParameter("boolean")).add((Object)MethodInvocationMatcher.create().typeDefinition("java.lang.System").name("runFinalizersOnExit").addParameter("boolean")).build();
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        MethodInvocationTreeImpl miti = (MethodInvocationTreeImpl)mit;
        this.addIssue((Tree)mit, "Remove this call to \"" + miti.getSymbol().owner().getName() + ".runFinalizersOnExit()\".");
    }
}

