/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractInjectionChecker;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2077", priority=Priority.CRITICAL, tags={"cwe", "owasp-top10", "security", "sql"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class SQLInjectionCheck
extends AbstractInjectionChecker {
    public void visitNode(Tree tree) {
        MethodInvocationTree methodTree = (MethodInvocationTree)tree;
        boolean isHibernateCall = this.isHibernateCall(methodTree);
        if (this.isHibernateCall(methodTree) || this.isExecuteQueryOrPrepareStatement(methodTree)) {
            ExpressionTree arg = (ExpressionTree)methodTree.arguments().get(0);
            this.parameterName = "";
            if (this.isDynamicString((Tree)methodTree, arg, null, true)) {
                String message = "\"" + this.parameterName + "\" is provided externally to the method and not sanitized before use.";
                if (isHibernateCall) {
                    message = "Use Hibernate's parameter binding instead of concatenation.";
                }
                this.addIssue((Tree)methodTree, message);
            }
        }
    }

    private boolean isExecuteQueryOrPrepareStatement(MethodInvocationTree methodTree) {
        if (methodTree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)methodTree.methodSelect();
            return !methodTree.arguments().isEmpty() && (this.isMethodCall("java.sql.Statement", "executeQuery", memberSelectExpressionTree) || this.isMethodCall("java.sql.Connection", "prepareStatement", memberSelectExpressionTree) || this.isMethodCall("java.sql.Connection", "prepareCall", memberSelectExpressionTree));
        }
        return false;
    }

    private boolean isHibernateCall(MethodInvocationTree methodTree) {
        if (methodTree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)methodTree.methodSelect();
            return !methodTree.arguments().isEmpty() && this.isMethodCall("org.hibernate.Session", "createQuery", memberSelectExpressionTree);
        }
        return false;
    }

    private boolean isMethodCall(String typeName, String methodName, MemberSelectExpressionTree memberSelectExpressionTree) {
        return methodName.equals(memberSelectExpressionTree.identifier().name()) && this.isInvokedOnType(typeName, memberSelectExpressionTree.expression());
    }

    private boolean isInvokedOnType(String type, ExpressionTree expressionTree) {
        Type selectorType = ((AbstractTypedTree)expressionTree).getSymbolType();
        if (selectorType.isTagged(10)) {
            Symbol.TypeSymbol symbol = selectorType.getSymbol();
            String selector = symbol.owner().getName() + "." + symbol.getName();
            return type.equals(selector) || this.checkInterfaces(type, symbol);
        }
        return false;
    }

    private boolean checkInterfaces(String type, Symbol.TypeSymbol symbol) {
        for (Type interfaceType : symbol.getInterfaces()) {
            Symbol.TypeSymbol interfaceSymbol = interfaceType.getSymbol();
            if (!type.equals(interfaceSymbol.owner().getName() + "." + interfaceSymbol.getName()) && !this.checkInterfaces(type, interfaceSymbol)) continue;
            return true;
        }
        return false;
    }
}

