/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.expression.MethodInvocationTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2092", priority=Priority.CRITICAL, tags={"cwe", "owasp-top10", "security"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class SecureCookieCheck
extends SubscriptionBaseVisitor {
    private List<Symbol> unsecuredCookies = Lists.newArrayList();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void scanFile(JavaFileScannerContext context) {
        this.unsecuredCookies.clear();
        super.scanFile(context);
        for (Symbol unsecuredCookie : this.unsecuredCookies) {
            this.addIssue(this.getSemanticModel().getTree(unsecuredCookie), "Add the \"secure\" attribute to this cookie");
        }
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            MemberSelectExpressionTree mse;
            MethodInvocationTreeImpl mit;
            if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                Symbol variableSymbol;
                VariableTree variableTree = (VariableTree)tree;
                Type type = ((AbstractTypedTree)variableTree.type()).getSymbolType();
                if (type.is("javax.servlet.http.Cookie") && this.isConstructorInitialized(variableTree) && (variableSymbol = this.getSemanticModel().getSymbol((Tree)variableTree)).owner().getType().isTagged(12)) {
                    this.unsecuredCookies.add(variableSymbol);
                }
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && this.isSetSecureCall(mit = (MethodInvocationTreeImpl)tree) && mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (mse = (MemberSelectExpressionTree)mit.methodSelect()).expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                Symbol reference = this.getSemanticModel().getReference((IdentifierTree)mse.expression());
                this.unsecuredCookies.remove(reference);
            }
        }
    }

    private boolean isConstructorInitialized(VariableTree variableTree) {
        return variableTree.initializer() != null && variableTree.initializer().is(new Tree.Kind[]{Tree.Kind.NEW_CLASS});
    }

    private boolean isSetSecureCall(MethodInvocationTreeImpl mit) {
        boolean hasArityOne;
        Symbol methodSymbol = mit.getSymbol();
        boolean bl = hasArityOne = mit.arguments().size() == 1;
        if (hasArityOne && this.isCallSiteCookie(methodSymbol)) {
            ExpressionTree expressionTree = (ExpressionTree)mit.arguments().get(0);
            if (expressionTree.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL}) && "false".equals(((LiteralTree)expressionTree).value())) {
                return false;
            }
            return "setSecure".equals(this.getIdentifier((MethodInvocationTree)mit).name());
        }
        return false;
    }

    private boolean isCallSiteCookie(Symbol methodSymbol) {
        return !methodSymbol.isKind(64) && methodSymbol.owner().getType().is("javax.servlet.http.Cookie");
    }

    private IdentifierTree getIdentifier(MethodInvocationTree mit) {
        IdentifierTree id = mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) ? (IdentifierTree)mit.methodSelect() : ((MemberSelectExpressionTree)mit.methodSelect()).identifier();
        return id;
    }
}

