/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.resolve.AnnotationValue;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2057", priority=Priority.MAJOR, tags={"pitfall", "serialization"})
public class SerialVersionUidCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            this.visitClassTree((ClassTreeImpl)tree);
        }
    }

    private void visitClassTree(ClassTreeImpl classTree) {
        Symbol.TypeSymbol symbol = classTree.getSymbol();
        if (this.isSerializable(symbol.getType())) {
            Symbol.VariableSymbol serialVersionUidSymbol = this.findSerialVersionUid(symbol);
            if (serialVersionUidSymbol == null) {
                if (!this.isExclusion(symbol)) {
                    this.addIssue((Tree)classTree, "Add a \"static final long serialVersionUID\" field to this class.");
                }
            } else {
                this.checkModifiers(serialVersionUidSymbol);
            }
        }
    }

    private void checkModifiers(Symbol.VariableSymbol serialVersionUidSymbol) {
        ArrayList missingModifiers = Lists.newArrayList();
        if (!serialVersionUidSymbol.isStatic()) {
            missingModifiers.add("static");
        }
        if (!serialVersionUidSymbol.isFinal()) {
            missingModifiers.add("final");
        }
        if (!serialVersionUidSymbol.getType().is("long")) {
            missingModifiers.add("long");
        }
        if (!missingModifiers.isEmpty()) {
            Tree tree = this.getSemanticModel().getTree((Symbol)serialVersionUidSymbol);
            this.addIssue(tree, "Make this \"serialVersionUID\" field \"" + Joiner.on((char)' ').join((Iterable)missingModifiers) + "\".");
        }
    }

    private Symbol.VariableSymbol findSerialVersionUid(Symbol.TypeSymbol symbol) {
        for (Symbol member : symbol.members().lookup("serialVersionUID")) {
            if (!member.isKind(4)) continue;
            return (Symbol.VariableSymbol)member;
        }
        return null;
    }

    private boolean isSerializable(Type type) {
        return type.isSubtypeOf("java.io.Serializable");
    }

    private boolean isExclusion(Symbol.TypeSymbol symbol) {
        return symbol.isAbstract() || symbol.getType().isSubtypeOf("java.lang.Throwable") || this.isGuiClass(symbol) || this.hasSuppressWarningAnnotation(symbol);
    }

    private boolean isGuiClass(Symbol.TypeSymbol symbol) {
        for (Type.ClassType superType : symbol.superTypes()) {
            Symbol.TypeSymbol superTypeSymbol = superType.getSymbol();
            if (!this.hasGuiPackage(superTypeSymbol)) continue;
            return true;
        }
        return this.hasGuiPackage(symbol) || !symbol.equals(symbol.outermostClass()) && this.isGuiClass(symbol.outermostClass());
    }

    private boolean hasGuiPackage(Symbol.TypeSymbol superTypeSymbol) {
        String fullyQualifiedName = superTypeSymbol.getFullyQualifiedName();
        return fullyQualifiedName.startsWith("javax.swing.") || fullyQualifiedName.startsWith("java.awt.");
    }

    private boolean hasSuppressWarningAnnotation(Symbol.TypeSymbol symbol) {
        List annotations = symbol.metadata().getValuesFor("java.lang.SuppressWarnings");
        if (annotations != null) {
            for (AnnotationValue annotationValue : annotations) {
                if (!"serial".equals(this.stringLiteralValue(annotationValue.value()))) continue;
                return true;
            }
        }
        return false;
    }

    private String stringLiteralValue(Object object) {
        if (object instanceof LiteralTree) {
            LiteralTree literal = (LiteralTree)object;
            return LiteralUtils.trimQuotes((String)literal.value());
        }
        return null;
    }
}

