/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2055", priority=Priority.CRITICAL, tags={"bug", "serialization"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class SerializableSuperConstructorCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        Type superclass;
        ClassTreeImpl classTree;
        Symbol.TypeSymbol classSymbol;
        if (this.hasSemantic() && this.isSerializable((classSymbol = (classTree = (ClassTreeImpl)tree).getSymbol()).getType()) && !this.isSerializable(classSymbol.getSuperclass()) && !this.hasNonPrivateNoArgConstructor(superclass = classSymbol.getSuperclass())) {
            this.addIssue(tree, "Add a no-arg constructor to \"" + superclass + "\".");
        }
    }

    private boolean isSerializable(Type type) {
        return type.isSubtypeOf("java.io.Serializable");
    }

    private boolean hasNonPrivateNoArgConstructor(Type type) {
        List constructors = type.getSymbol().members().lookup("<init>");
        for (Symbol member : constructors) {
            Symbol.MethodSymbol method;
            if (!member.isKind(16) || !(method = (Symbol.MethodSymbol)member).getParametersTypes().isEmpty() || method.isPrivate()) continue;
            return true;
        }
        return constructors.isEmpty();
    }
}

