/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S2183", priority=Priority.CRITICAL, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class ShiftOnIntOrLongCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.LEFT_SHIFT, (Object)Tree.Kind.LEFT_SHIFT_ASSIGNMENT, (Object)Tree.Kind.RIGHT_SHIFT, (Object)Tree.Kind.RIGHT_SHIFT_ASSIGNMENT);
    }

    public void visitNode(Tree tree) {
        int sign;
        ExpressionTree shift;
        String identifier;
        if (tree.is(new Tree.Kind[]{Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT})) {
            BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)tree;
            if (this.isZeroMaskShift(binaryExpressionTree)) {
                return;
            }
            identifier = this.getIdentifierName(binaryExpressionTree.leftOperand());
            shift = binaryExpressionTree.rightOperand();
        } else {
            AssignmentExpressionTree assignmentExpressionTree = (AssignmentExpressionTree)tree;
            identifier = this.getIdentifierName(assignmentExpressionTree.variable());
            shift = assignmentExpressionTree.expression();
        }
        int n = sign = shift.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS}) ? -1 : 1;
        if (shift.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS})) {
            shift = ((UnaryExpressionTree)shift).expression();
        }
        if (shift.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL})) {
            long reducedNumberBits;
            int base = this.getBase(tree);
            long numberBits = (long)sign * Long.decode(this.trimLongSuffix(((LiteralTree)shift).value()));
            String message = this.getMessage(numberBits, reducedNumberBits = numberBits % (long)base, base, identifier);
            if (message != null) {
                this.addIssue(tree, message);
            }
        }
    }

    private boolean isZeroMaskShift(BinaryExpressionTree binaryExpressionTree) {
        return this.isLiteralValue(binaryExpressionTree.leftOperand(), 1L) && this.isLiteralValue(binaryExpressionTree.rightOperand(), 0L);
    }

    private boolean isLiteralValue(ExpressionTree tree, long value) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL})) {
            return Long.decode(this.trimLongSuffix(((LiteralTree)tree).value())) == value;
        }
        return false;
    }

    private String trimLongSuffix(String longString) {
        int lastCharPosition = longString.length() - 1;
        char lastChar = longString.charAt(lastCharPosition);
        String value = longString;
        if (lastChar == 'L' || lastChar == 'l') {
            value = longString.substring(0, lastCharPosition);
        }
        return value;
    }

    private String getMessage(long numberBits, long reducedNumberBits, int base, String identifier) {
        if (reducedNumberBits == 0L) {
            return "Remove this useless shift";
        }
        if (this.tooManyBits(numberBits, base)) {
            if (base == 32) {
                return MessageFormat.format(identifier == null ? "Either use a \"long\" or correct this shift to {0}" : "Either make \"{1}\" a \"long\" or correct this shift to {0}", reducedNumberBits, identifier);
            }
            return MessageFormat.format("Correct this shift to {0}", reducedNumberBits);
        }
        return null;
    }

    private int getBase(Tree tree) {
        if (((AbstractTypedTree)tree).getSymbolType().is("int")) {
            return 32;
        }
        return 64;
    }

    private boolean tooManyBits(long numberBits, int base) {
        return Math.abs(numberBits) >= (long)base;
    }

    private String getIdentifierName(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ARRAY_ACCESS_EXPRESSION})) {
            return this.getIdentifierName(((ArrayAccessExpressionTree)tree).expression());
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)tree).name();
        }
        return null;
    }
}

