/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2130", priority=Priority.MAJOR, tags={"performance"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class StringToPrimitiveConversionCheck
extends SubscriptionBaseVisitor {
    private final List<PrimitiveCheck> primitiveChecks = this.buildPrimitiveChecks();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                VariableTreeImpl variableTree = (VariableTreeImpl)tree;
                Type variableType = variableTree.getSymbol().getType();
                PrimitiveCheck primitiveCheck = this.getPrimitiveCheck(variableType);
                ExpressionTree initializer = variableTree.initializer();
                if (primitiveCheck != null && initializer != null) {
                    primitiveCheck.checkInstanciation(initializer);
                }
            } else {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
                for (PrimitiveCheck primitiveCheck : this.primitiveChecks) {
                    primitiveCheck.checkMethodInvocation(methodInvocationTree);
                }
            }
        }
    }

    private PrimitiveCheck getPrimitiveCheck(Type type) {
        if (!type.isPrimitive()) {
            return null;
        }
        for (PrimitiveCheck primitiveCheck : this.primitiveChecks) {
            if (!type.isTagged(primitiveCheck.tag)) continue;
            return primitiveCheck;
        }
        return null;
    }

    private List<PrimitiveCheck> buildPrimitiveChecks() {
        return ImmutableList.of((Object)new PrimitiveCheck("int", "Integer", 4), (Object)new PrimitiveCheck("boolean", "Boolean", 8), (Object)new PrimitiveCheck("byte", "Byte", 1), (Object)new PrimitiveCheck("double", "Double", 7), (Object)new PrimitiveCheck("float", "Float", 6), (Object)new PrimitiveCheck("long", "Long", 5), (Object)new PrimitiveCheck("short", "Short", 3));
    }

    private class PrimitiveCheck {
        private final String primitiveName;
        private final String className;
        private final int tag;
        private final String message;
        private final MethodInvocationMatcher unboxingInvocationMatcher;
        private final MethodInvocationMatcher valueOfInvocationMatcher;

        private PrimitiveCheck(String primitiveName, String className, int tag) {
            this.primitiveName = primitiveName;
            this.className = className;
            this.tag = tag;
            this.message = "Use \"" + this.parseMethodName() + "\" for this string-to-" + primitiveName + " conversion.";
            this.unboxingInvocationMatcher = MethodInvocationMatcher.create().typeDefinition("java.lang." + className).name(primitiveName + "Value");
            this.valueOfInvocationMatcher = MethodInvocationMatcher.create().typeDefinition("java.lang." + className).name("valueOf").addParameter("java.lang.String");
        }

        private void checkMethodInvocation(MethodInvocationTree methodInvocationTree) {
            if (this.unboxingInvocationMatcher.matches(methodInvocationTree, StringToPrimitiveConversionCheck.this.getSemanticModel())) {
                MemberSelectExpressionTree methodSelect = (MemberSelectExpressionTree)methodInvocationTree.methodSelect();
                this.checkInstanciation(methodSelect.expression());
            }
        }

        private void checkInstanciation(ExpressionTree expression) {
            if (this.isBadlyInstanciated(expression)) {
                StringToPrimitiveConversionCheck.this.addIssue((Tree)expression, this.message);
            }
        }

        private boolean isBadlyInstanciated(ExpressionTree expression) {
            boolean result = false;
            if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
                result = this.isStringBasedConstructor((NewClassTree)expression);
            } else if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                result = this.valueOfInvocationMatcher.matches((MethodInvocationTree)expression, StringToPrimitiveConversionCheck.this.getSemanticModel());
            } else if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                IdentifierTree identifier = (IdentifierTree)expression;
                Symbol reference = StringToPrimitiveConversionCheck.this.getSemanticModel().getReference(identifier);
                if (reference != null && reference.isKind(4) && StringToPrimitiveConversionCheck.this.getSemanticModel().getUsages(reference).size() == 1) {
                    Symbol.VariableSymbol variableSymbol = (Symbol.VariableSymbol)reference;
                    result = this.isBadlyInstanciatedVariable(variableSymbol);
                }
            }
            return result;
        }

        private boolean isBadlyInstanciatedVariable(Symbol.VariableSymbol variableSymbol) {
            VariableTree variableTree;
            ExpressionTree initializer;
            Tree tree = StringToPrimitiveConversionCheck.this.getSemanticModel().getTree((Symbol)variableSymbol);
            if (tree != null && tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && (initializer = (variableTree = (VariableTree)tree).initializer()) != null) {
                return this.isBadlyInstanciated(variableTree.initializer());
            }
            return false;
        }

        private boolean isStringBasedConstructor(NewClassTree newClassTree) {
            List arguments = newClassTree.arguments();
            return ((AbstractTypedTree)arguments.get(0)).getSymbolType().is("java.lang.String");
        }

        private String parseMethodName() {
            return this.className + ".parse" + StringUtils.capitalize((String)this.primitiveName);
        }
    }
}

