/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1860", priority=Priority.BLOCKER, tags={"bug", "cert"})
@BelongsToProfile(title="Sonar way", priority=Priority.BLOCKER)
public class SynchronizationOnStringOrBoxedCheck
extends SubscriptionBaseVisitor {
    private static final List<String> FORBIDDEN_TYPES = ImmutableList.of((Object)Boolean.class.getName(), (Object)Byte.class.getName(), (Object)Character.class.getName(), (Object)Double.class.getName(), (Object)Float.class.getName(), (Object)Integer.class.getName(), (Object)Long.class.getName(), (Object)Short.class.getName(), (Object)String.class.getName());

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.SYNCHRONIZED_STATEMENT);
    }

    public void visitNode(Tree tree) {
        SynchronizedStatementTree syncStatement = (SynchronizedStatementTree)tree;
        AbstractTypedTree expression = (AbstractTypedTree)syncStatement.expression();
        Type expressionType = expression.getSymbolType();
        if (expressionType.isPrimitive() || this.isForbiddenType(expressionType)) {
            this.addIssue((Tree)syncStatement, "Synchronize on a new \"Object\" instead.");
        }
    }

    private boolean isForbiddenType(Type expressionType) {
        for (String forbiddenType : FORBIDDEN_TYPES) {
            if (!expressionType.is(forbiddenType)) continue;
            return true;
        }
        return false;
    }
}

