/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2236", priority=Priority.CRITICAL, tags={"bug", "multi-threading"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class ThreadWaitCallCheck
extends AbstractMethodDetection {
    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        this.addIssue((Tree)mit, "Refactor the synchronisation mechanism to not use a Thread instance as a monitor");
    }

    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        TypeCriteria subtypeOfThread = TypeCriteria.subtypeOf("java.lang.Thread");
        return ImmutableList.builder().add((Object)MethodInvocationMatcher.create().callSite(subtypeOfThread).name("wait")).add((Object)MethodInvocationMatcher.create().callSite(subtypeOfThread).name("wait").addParameter("long")).add((Object)MethodInvocationMatcher.create().callSite(subtypeOfThread).name("wait").addParameter("long").addParameter("int")).add((Object)MethodInvocationMatcher.create().callSite(subtypeOfThread).name("notify")).add((Object)MethodInvocationMatcher.create().callSite(subtypeOfThread).name("notifyAll")).build();
    }
}

