/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2230", priority=Priority.CRITICAL, tags={"bug", "spring"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class TransactionalMethodVisibilityCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree method = (MethodTree)tree;
        boolean isPublic = method.modifiers().modifiers().contains(Modifier.PUBLIC);
        if (!isPublic && this.hasTransactionalAnnotation(method)) {
            this.addIssue((Tree)method, "Make this method \"public\" or remove the \"@Transactional\" annotation");
        }
    }

    private boolean hasTransactionalAnnotation(MethodTree method) {
        for (AnnotationTree annotation : method.modifiers().annotations()) {
            Type annotationType = ((AbstractTypedTree)annotation).getSymbolType();
            if (!annotationType.is("org.springframework.transaction.annotation.Transactional")) continue;
            return true;
        }
        return false;
    }
}

