/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2065", priority=Priority.MINOR, tags={"unused", "serialization"})
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class TransientFieldInNonSerializableCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTreeImpl classTree = (ClassTreeImpl)tree;
        if (this.hasSemantic() && this.isNotSerializable(classTree.getSymbol())) {
            for (Tree member : classTree.members()) {
                if (!this.isTransient(member)) continue;
                this.addIssue(member, "Remove the \"transient\" modifier from this field.");
            }
        }
    }

    private boolean isNotSerializable(Symbol.TypeSymbol symbol) {
        for (Type.ClassType superType : symbol.superTypes()) {
            if (!superType.isTagged(14)) continue;
            return false;
        }
        return !symbol.getType().isSubtypeOf("java.io.Serializable");
    }

    private boolean isTransient(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            VariableTree variable = (VariableTree)tree;
            return variable.modifiers().modifiers().contains(Modifier.TRANSIENT);
        }
        return false;
    }
}

