/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1844", priority=Priority.BLOCKER, tags={"bug", "pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.BLOCKER)
public class WaitOnConditionCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        TypeCriteria conditionSubType = TypeCriteria.subtypeOf("java.util.concurrent.locks.Condition");
        return ImmutableList.builder().add((Object)MethodInvocationMatcher.create().callSite(conditionSubType).name("wait")).add((Object)MethodInvocationMatcher.create().callSite(conditionSubType).name("wait").addParameter("long")).add((Object)MethodInvocationMatcher.create().callSite(conditionSubType).name("wait").addParameter("long").addParameter("int")).build();
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        this.addIssue((Tree)mit, "The \"Condition.await(...)\" method should be used instead of \"Object.wait(...)\"");
    }
}

