/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1610", name="Abstract classes without fields should be converted to interfaces", tags={"java8"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="ARCHITECTURE_CHANGEABILITY")
@SqaleConstantRemediation(value="10min")
public class AbstractClassNoFieldShouldBeInterfaceCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        if (this.classIsAbstract(tree) && this.classHasNoField(tree) && !this.classHasProtectedMethod(tree)) {
            this.context.addIssue((Tree)tree, (JavaCheck)this, "Convert the abstract class \"" + tree.simpleName().name() + "\" into an interface");
        }
        super.visitClass(tree);
    }

    private boolean classHasProtectedMethod(ClassTree tree) {
        for (Tree member : tree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD}) || !((MethodTree)member).modifiers().modifiers().contains(Modifier.PROTECTED)) continue;
            return true;
        }
        return false;
    }

    private boolean classIsAbstract(ClassTree tree) {
        return tree.modifiers().modifiers().contains(Modifier.ABSTRACT);
    }

    private boolean classHasNoField(ClassTree tree) {
        for (Tree member : tree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
            return false;
        }
        return true;
    }
}

