/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1604", name="Anonymous inner classes containing only one method should become lambdas", tags={"java8"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class AnonymousClassShouldBeLambdaCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private List<IdentifierTree> enumConstants;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.enumConstants = Lists.newArrayList();
        this.scan((Tree)context.getTree());
    }

    public void visitEnumConstant(EnumConstantTree tree) {
        this.enumConstants.add(tree.simpleName());
        super.visitEnumConstant(tree);
        this.enumConstants.remove(tree.simpleName());
    }

    public void visitNewClass(NewClassTree tree) {
        super.visitNewClass(tree);
        if (tree.classBody() != null) {
            List members = tree.classBody().members();
            if (!this.useThisIdentifier(tree.classBody()) && !this.enumConstants.contains(tree.identifier()) && members.size() == 1 && ((Tree)members.get(0)).is(new Tree.Kind[]{Tree.Kind.METHOD})) {
                this.context.addIssue((Tree)tree.identifier(), (JavaCheck)this, "Make this anonymous inner class a lambda");
            }
        }
    }

    private boolean useThisIdentifier(ClassTree body) {
        ThisIdentifierVisitor visitor = new ThisIdentifierVisitor();
        body.accept((TreeVisitor)visitor);
        return visitor.usesThisIdentifier;
    }

    private static class ThisIdentifierVisitor
    extends BaseTreeVisitor {
        boolean usesThisIdentifier = false;
        boolean visitedClassTree = false;

        private ThisIdentifierVisitor() {
        }

        public void visitClass(ClassTree tree) {
            if (!this.visitedClassTree) {
                this.visitedClassTree = true;
                super.visitClass(tree);
            }
        }

        public void visitNewClass(NewClassTree tree) {
        }

        public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            this.scan((Tree)tree.expression());
        }

        public void visitIdentifier(IdentifierTree tree) {
            this.usesThisIdentifier |= "this".equals(tree.name());
        }
    }
}

