/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S00116", name="Field names should comply with a naming convention", tags={"convention"}, priority=Priority.MINOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class BadFieldName_S00116_Check
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String DEFAULT_FORMAT = "^[a-z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", description="Regular expression used to check the field names against.", defaultValue="^[a-z][a-zA-Z0-9]*$")
    public String format = "^[a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        for (Tree member : tree.members()) {
            VariableTree field;
            if ((tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) || tree.is(new Tree.Kind[]{Tree.Kind.ENUM})) && member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && this.isNotStatic(field = (VariableTree)member) && !this.pattern.matcher(field.simpleName().name()).matches()) {
                this.context.addIssue((Tree)field, (JavaCheck)this, "Rename this field name to match the regular expression '" + this.format + "'.");
            }
            this.scan(member);
        }
    }

    private boolean isNotStatic(VariableTree field) {
        for (Modifier modifier : field.modifiers().modifiers()) {
            if (modifier != Modifier.STATIC) continue;
            return false;
        }
        return true;
    }
}

