/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S00100", name="Method names should comply with a naming convention", tags={"convention"}, priority=Priority.MINOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class BadMethodName_S00100_Check
extends SubscriptionBaseVisitor {
    private static final String DEFAULT_FORMAT = "^[a-z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", description="Regular expression used to check the method names against.", defaultValue="^[a-z][a-zA-Z0-9]*$")
    public String format = "^[a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        super.scanFile(context);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (this.isNotOverriden(methodTree) && !this.pattern.matcher(methodTree.simpleName().name()).matches()) {
            this.addIssue(tree, "Rename this method name to match the regular expression '" + this.format + "'.");
        }
    }

    private boolean isNotOverriden(MethodTree methodTree) {
        return BooleanUtils.isFalse((Boolean)((MethodTreeImpl)methodTree).isOverriding());
    }
}

