/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.checks.methods.MethodInvocationMatcherCollection;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1181", name="Throwable and Error should not be caught", tags={"cert", "cwe", "error-handling"}, priority=Priority.BLOCKER)
@ActivatedByDefault
@SqaleSubCharacteristic(value="EXCEPTION_HANDLING")
@SqaleConstantRemediation(value="20min")
public class CatchOfThrowableOrErrorCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CATCH);
    }

    public void visitNode(Tree tree) {
        CatchTree catchTree = (CatchTree)tree;
        TypeTree typeTree = catchTree.parameter().type();
        if (typeTree.is(new Tree.Kind[]{Tree.Kind.UNION_TYPE})) {
            for (TypeTree alternativeTypeTree : ((UnionTypeTree)typeTree).typeAlternatives()) {
                this.checkType(alternativeTypeTree, catchTree);
            }
        } else {
            this.checkType(typeTree, catchTree);
        }
    }

    private void checkType(TypeTree typeTree, CatchTree catchTree) {
        Type type = typeTree.symbolType();
        if (type.is("java.lang.Error")) {
            this.insertIssue(typeTree, type);
        } else if (type.is("java.lang.Throwable")) {
            GuavaCloserRethrowVisitor visitor = new GuavaCloserRethrowVisitor(catchTree.parameter().symbol());
            catchTree.block().accept((TreeVisitor)visitor);
            if (!visitor.foundRethrow) {
                this.insertIssue(typeTree, type);
            }
        }
    }

    private void insertIssue(TypeTree typeTree, Type type) {
        this.addIssue((Tree)typeTree, "Catch Exception instead of " + type.name() + ".");
    }

    private static class GuavaCloserRethrowVisitor
    extends BaseTreeVisitor {
        private static final String JAVA_LANG_CLASS = "java.lang.Class";
        private static final MethodInvocationMatcherCollection MATCHERS = MethodInvocationMatcherCollection.create(GuavaCloserRethrowVisitor.rethrowMethod(), GuavaCloserRethrowVisitor.rethrowMethod().addParameter("java.lang.Class"), GuavaCloserRethrowVisitor.rethrowMethod().addParameter("java.lang.Class").addParameter("java.lang.Class"));
        private boolean foundRethrow = false;
        private final Symbol exceptionSymbol;

        public GuavaCloserRethrowVisitor(Symbol exceptionSymbol) {
            this.exceptionSymbol = exceptionSymbol;
        }

        public void visitThrowStatement(ThrowStatementTree tree) {
            if (this.isGuavaCloserRethrow(tree.expression())) {
                this.foundRethrow = true;
            }
        }

        private boolean isGuavaCloserRethrow(ExpressionTree expression) {
            MethodInvocationTree mit;
            if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && MATCHERS.anyMatch(mit = (MethodInvocationTree)expression)) {
                ExpressionTree firstArgument = (ExpressionTree)mit.arguments().get(0);
                return firstArgument.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && this.exceptionSymbol.equals(((IdentifierTree)firstArgument).symbol());
            }
            return false;
        }

        private static MethodInvocationMatcher rethrowMethod() {
            return MethodInvocationMatcher.create().typeDefinition("com.google.common.io.Closer").name("rethrow").addParameter("java.lang.Throwable");
        }
    }
}

