/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.checks.methods.MethodInvocationMatcherCollection;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1872", name="Classes should not be compared by name", tags={"bug", "cwe"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ClassComparedByNameCheck
extends AbstractMethodDetection {
    private ClassGetNameDetector classGetNameDetector = new ClassGetNameDetector();

    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodInvocationMatcher.create().typeDefinition("java.lang.String").name("equals").withNoParameterConstraint());
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ((MemberSelectExpressionTree)mit.methodSelect()).expression().accept((TreeVisitor)this.classGetNameDetector);
        }
        ((ExpressionTree)mit.arguments().get(0)).accept((TreeVisitor)this.classGetNameDetector);
    }

    private class ClassGetNameDetector
    extends BaseTreeVisitor {
        private final MethodInvocationMatcherCollection methodMatchers = MethodInvocationMatcherCollection.create(MethodInvocationMatcher.create().typeDefinition("java.lang.Class").name("getName"), MethodInvocationMatcher.create().typeDefinition("java.lang.Class").name("getSimpleName"));

        private ClassGetNameDetector() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (this.methodMatchers.anyMatch(tree)) {
                ClassComparedByNameCheck.this.addIssue((Tree)tree, "Use an \"instanceof\" comparison instead.");
            }
            this.scan((Tree)tree.methodSelect());
        }
    }
}

