/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2157", name="\"Cloneables\" should implement \"clone\"", tags={"bug"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="30min")
public class CloneableImplementingCloneCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        Symbol.TypeSymbol classSymbol = classTree.symbol();
        if (this.isCloneable(classTree) && !classSymbol.isAbstract() && !this.declaresCloneMethod(classSymbol)) {
            this.addIssue(tree, "Add a \"clone()\" method to this class.");
        }
    }

    private boolean declaresCloneMethod(Symbol.TypeSymbol classSymbol) {
        for (Symbol memberSymbol : classSymbol.lookupSymbols("clone")) {
            Symbol.MethodSymbol methodSymbol;
            if (!memberSymbol.isMethodSymbol() || !(methodSymbol = (Symbol.MethodSymbol)memberSymbol).parameterTypes().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean isCloneable(ClassTree classTree) {
        for (TypeTree superInterface : classTree.superInterfaces()) {
            if (!superInterface.symbolType().is("java.lang.Cloneable")) continue;
            return true;
        }
        return false;
    }
}

